/*
 * error handling definitions for Fabric Management server
 */

#include <stdio.h>
#include <errno.h>

#define FMS_MAX_ERROR_DEPTH 10

/*
 * Global variables for the error handling subsystem
 */

/*
 * Macros for reporting errors
 */

#define LF_ERROR(p)                                 \
  do {                                              \
    errno = 0;					    \
    LF_ERROR_E(p);				    \
  } while (0)

#define LF_ERROR_E(p)							\
  do {									\
    char *__errstr;							\
    __errstr = lf_error_msg_fmt p;					\
    fms_save_error(__FILE__, __LINE__, errno, __errstr);		\
    lf_error_msg_free(__errstr);                                        \
    errno = 0;								\
    goto except;							\
  } while (0)

/*
 * error handling routine
 */
void fms_save_error(char *, int, int, char *);
void fms_perror(void);
void fms_init_error_vars(void);
void fms_init_error(void);
void fms_reset_errors(void);
void fms_error_copy(char *dest);
